@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property and Configuration block for specifying rule filters. This element is required only if you specify more than one filter. See and below for more details.
 * @property prefix Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property tag Configuration block for specifying a tag key and value. See below.
 */
public data class BucketReplicationConfigRuleFilter(
    public val and: BucketReplicationConfigRuleFilterAnd? = null,
    public val prefix: String? = null,
    public val tag: BucketReplicationConfigRuleFilterTag? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigRuleFilter):
            BucketReplicationConfigRuleFilter = BucketReplicationConfigRuleFilter(
            and = javaType.and().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleFilterAnd.Companion.toKotlin(args0)
                })
            }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleFilterTag.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
