@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property role The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
 * @property rules Specifies the rules managing the replication (documented below).
 */
public data class BucketReplicationConfiguration(
    public val role: String,
    public val rules: List<BucketReplicationConfigurationRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfiguration):
            BucketReplicationConfiguration = BucketReplicationConfiguration(
            role = javaType.role(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigurationRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
