@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteMarkerReplicationStatus Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
 * @property destination Specifies the destination for the rule (documented below).
 * @property filter Filter that identifies subset of objects to which the replication rule applies (documented below).
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property prefix Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property priority The priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
 * @property sourceSelectionCriteria Specifies special object selection criteria (documented below).
 * @property status The status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
 * > **NOTE:** Replication to multiple destination buckets requires that `priority` is specified in the `rules` object. If the corresponding rule requires no filter, an empty configuration block `filter {}` must be specified.
 */
public data class BucketReplicationConfigurationRule(
    public val deleteMarkerReplicationStatus: String? = null,
    public val destination: BucketReplicationConfigurationRuleDestination,
    public val filter: BucketReplicationConfigurationRuleFilter? = null,
    public val id: String? = null,
    public val prefix: String? = null,
    public val priority: Int? = null,
    public val sourceSelectionCriteria: BucketReplicationConfigurationRuleSourceSelectionCriteria? =
        null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigurationRule):
            BucketReplicationConfigurationRule = BucketReplicationConfigurationRule(
            deleteMarkerReplicationStatus = javaType.deleteMarkerReplicationStatus().map({ args0 ->
                args0
            }).orElse(null),
            destination = javaType.destination().let({ args0 ->
                com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigurationRuleDestination.Companion.toKotlin(args0)
            }),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigurationRuleFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            sourceSelectionCriteria = javaType.sourceSelectionCriteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigurationRuleSourceSelectionCriteria.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
        )
    }
}
