@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessControlTranslation Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
 * @property accountId The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
 * @property bucket The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
 * @property metrics Enables replication metrics (required for S3 RTC) (documented below).
 * @property replicaKmsKeyId Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
 * `sse_kms_encrypted_objects` source selection criteria.
 * @property replicationTime Enables S3 Replication Time Control (S3 RTC) (documented below).
 * @property storageClass The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
 */
public data class BucketReplicationConfigurationRuleDestination(
    public val accessControlTranslation:
    BucketReplicationConfigurationRuleDestinationAccessControlTranslation? = null,
    public val accountId: String? = null,
    public val bucket: String,
    public val metrics: BucketReplicationConfigurationRuleDestinationMetrics? = null,
    public val replicaKmsKeyId: String? = null,
    public val replicationTime: BucketReplicationConfigurationRuleDestinationReplicationTime? = null,
    public val storageClass: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigurationRuleDestination):
            BucketReplicationConfigurationRuleDestination =
            BucketReplicationConfigurationRuleDestination(
                accessControlTranslation = javaType.accessControlTranslation().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslation.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
                bucket = javaType.bucket(),
                metrics = javaType.metrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigurationRuleDestinationMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                replicaKmsKeyId = javaType.replicaKmsKeyId().map({ args0 -> args0 }).orElse(null),
                replicationTime = javaType.replicationTime().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigurationRuleDestinationReplicationTime.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                storageClass = javaType.storageClass().map({ args0 -> args0 }).orElse(null),
            )
    }
}
