@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property minutes Threshold within which objects are to be replicated. The only valid value is `15`.
 * @property status The status of replication metrics. Either `Enabled` or `Disabled`.
 */
public data class BucketReplicationConfigurationRuleDestinationMetrics(
    public val minutes: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigurationRuleDestinationMetrics):
            BucketReplicationConfigurationRuleDestinationMetrics =
            BucketReplicationConfigurationRuleDestinationMetrics(
                minutes = javaType.minutes().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
