@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property applyServerSideEncryptionByDefault A single object for setting server-side encryption by default. (documented below)
 * @property bucketKeyEnabled Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
 */
public data class BucketServerSideEncryptionConfigurationRule(
    public val applyServerSideEncryptionByDefault:
    BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault,
    public val bucketKeyEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketServerSideEncryptionConfigurationRule):
            BucketServerSideEncryptionConfigurationRule = BucketServerSideEncryptionConfigurationRule(
            applyServerSideEncryptionByDefault = javaType.applyServerSideEncryptionByDefault().let({ args0 ->
                com.pulumi.aws.s3.kotlin.outputs.BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault.Companion.toKotlin(args0)
            }),
            bucketKeyEnabled = javaType.bucketKeyEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
