@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property deleteMarkerReplicationStatus Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
 * @property destinations Specifies the destination for the rule (documented below).
 * @property filters Filter that identifies subset of objects to which the replication rule applies (documented below).
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property prefix Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property priority Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
 * @property sourceSelectionCriterias Specifies special object selection criteria (documented below).
 * @property status Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
 */
public data class BucketV2ReplicationConfigurationRule(
    public val deleteMarkerReplicationStatus: String? = null,
    public val destinations: List<BucketV2ReplicationConfigurationRuleDestination>,
    public val filters: List<BucketV2ReplicationConfigurationRuleFilter>? = null,
    public val id: String? = null,
    public val prefix: String? = null,
    public val priority: Int? = null,
    public val sourceSelectionCriterias:
    List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteria>? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2ReplicationConfigurationRule):
            BucketV2ReplicationConfigurationRule = BucketV2ReplicationConfigurationRule(
            deleteMarkerReplicationStatus = javaType.deleteMarkerReplicationStatus().map({ args0 ->
                args0
            }).orElse(null),
            destinations = javaType.destinations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfigurationRuleDestination.Companion.toKotlin(args0)
                })
            }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfigurationRuleFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            sourceSelectionCriterias = javaType.sourceSelectionCriterias().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteria.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
        )
    }
}
