@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessControlTranslations Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
 * @property accountId Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
 * @property bucket ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
 * @property metrics Enables replication metrics (required for S3 RTC) (documented below).
 * @property replicaKmsKeyId Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
 * `sse_kms_encrypted_objects` source selection criteria.
 * @property replicationTimes Enables S3 Replication Time Control (S3 RTC) (documented below).
 * @property storageClass The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
 */
public data class BucketV2ReplicationConfigurationRuleDestination(
    public val accessControlTranslations:
    List<BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation>? = null,
    public val accountId: String? = null,
    public val bucket: String,
    public val metrics: List<BucketV2ReplicationConfigurationRuleDestinationMetric>? = null,
    public val replicaKmsKeyId: String? = null,
    public val replicationTimes: List<BucketV2ReplicationConfigurationRuleDestinationReplicationTime>? =
        null,
    public val storageClass: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2ReplicationConfigurationRuleDestination):
            BucketV2ReplicationConfigurationRuleDestination =
            BucketV2ReplicationConfigurationRuleDestination(
                accessControlTranslations = javaType.accessControlTranslations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation.Companion.toKotlin(args0)
                    })
                }),
                accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
                bucket = javaType.bucket(),
                metrics = javaType.metrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfigurationRuleDestinationMetric.Companion.toKotlin(args0)
                    })
                }),
                replicaKmsKeyId = javaType.replicaKmsKeyId().map({ args0 -> args0 }).orElse(null),
                replicationTimes = javaType.replicationTimes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfigurationRuleDestinationReplicationTime.Companion.toKotlin(args0)
                    })
                }),
                storageClass = javaType.storageClass().map({ args0 -> args0 }).orElse(null),
            )
    }
}
