@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
 * @property mfaDelete Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
 */
public data class BucketVersioning(
    public val enabled: Boolean? = null,
    public val mfaDelete: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketVersioning): BucketVersioning =
            BucketVersioning(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                mfaDelete = javaType.mfaDelete().map({ args0 -> args0 }).orElse(null),
            )
    }
}
