@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property errorDocument An absolute path to the document to return in case of a 4XX error.
 * @property indexDocument Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
 * @property redirectAllRequestsTo A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
 * @property routingRules A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
 * describing redirect behavior and when redirects are applied.
 * The `CORS` object supports the following:
 */
public data class BucketWebsite(
    public val errorDocument: String? = null,
    public val indexDocument: String? = null,
    public val redirectAllRequestsTo: String? = null,
    public val routingRules: Either<String, List<String>>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketWebsite): BucketWebsite =
            BucketWebsite(
                errorDocument = javaType.errorDocument().map({ args0 -> args0 }).orElse(null),
                indexDocument = javaType.indexDocument().map({ args0 -> args0 }).orElse(null),
                redirectAllRequestsTo = javaType.redirectAllRequestsTo().map({ args0 -> args0 }).orElse(null),
                routingRules = javaType.routingRules().map({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.map({ args0 -> args0 })
                    })
                }).orElse(null),
            )
    }
}
