@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hostName Name of the host where requests are redirected.
 * @property protocol Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
 */
public data class BucketWebsiteConfigurationV2RedirectAllRequestsTo(
    public val hostName: String,
    public val protocol: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2RedirectAllRequestsTo):
            BucketWebsiteConfigurationV2RedirectAllRequestsTo =
            BucketWebsiteConfigurationV2RedirectAllRequestsTo(
                hostName = javaType.hostName(),
                protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            )
    }
}
