@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hostName Host name to use in the redirect request.
 * @property httpRedirectCode HTTP redirect code to use on the response.
 * @property protocol Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
 * @property replaceKeyPrefixWith Object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix `docs/` (objects in the `docs/` folder) to `documents/`, you can set a `condition` block with `key_prefix_equals` set to `docs/` and in the `redirect` set `replace_key_prefix_with` to `/documents`.
 * @property replaceKeyWith Specific object key to use in the redirect request. For example, redirect request to `error.html`.
 */
public data class BucketWebsiteConfigurationV2RoutingRuleRedirect(
    public val hostName: String? = null,
    public val httpRedirectCode: String? = null,
    public val protocol: String? = null,
    public val replaceKeyPrefixWith: String? = null,
    public val replaceKeyWith: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2RoutingRuleRedirect):
            BucketWebsiteConfigurationV2RoutingRuleRedirect =
            BucketWebsiteConfigurationV2RoutingRuleRedirect(
                hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
                httpRedirectCode = javaType.httpRedirectCode().map({ args0 -> args0 }).orElse(null),
                protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
                replaceKeyPrefixWith = javaType.replaceKeyPrefixWith().map({ args0 -> args0 }).orElse(null),
                replaceKeyWith = javaType.replaceKeyWith().map({ args0 -> args0 }).orElse(null),
            )
    }
}
