@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name [Availability Zone ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#az-ids).
 * @property type Location type. Valid values: `AvailabilityZone`.
 */
public data class DirectoryBucketLocation(
    public val name: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.DirectoryBucketLocation):
            DirectoryBucketLocation = DirectoryBucketLocation(
            name = javaType.name(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
