@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBucketObjects.
 * @property bucket
 * @property commonPrefixes List of any keys between `prefix` and the next occurrence of `delimiter` (i.e., similar to subdirectories of the `prefix` "directory"); the list is only returned when you specify `delimiter`
 * @property delimiter
 * @property encodingType
 * @property fetchOwner
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keys List of strings representing object keys
 * @property maxKeys
 * @property owners List of strings representing object owner IDs (see `fetch_owner` above)
 * @property prefix
 * @property startAfter
 */
public data class GetBucketObjectsResult(
    @Deprecated(
        message = """
  Use the aws_s3_objects data source instead
  """,
    )
    public val bucket: String,
    public val commonPrefixes: List<String>,
    public val delimiter: String? = null,
    public val encodingType: String? = null,
    public val fetchOwner: Boolean? = null,
    public val id: String,
    public val keys: List<String>,
    public val maxKeys: Int? = null,
    public val owners: List<String>,
    public val prefix: String? = null,
    public val startAfter: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.GetBucketObjectsResult):
            GetBucketObjectsResult = GetBucketObjectsResult(
            bucket = javaType.bucket(),
            commonPrefixes = javaType.commonPrefixes().map({ args0 -> args0 }),
            delimiter = javaType.delimiter().map({ args0 -> args0 }).orElse(null),
            encodingType = javaType.encodingType().map({ args0 -> args0 }).orElse(null),
            fetchOwner = javaType.fetchOwner().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            keys = javaType.keys().map({ args0 -> args0 }),
            maxKeys = javaType.maxKeys().map({ args0 -> args0 }).orElse(null),
            owners = javaType.owners().map({ args0 -> args0 }),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            startAfter = javaType.startAfter().map({ args0 -> args0 }).orElse(null),
        )
    }
}
