@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getBucketPolicy.
 * @property bucket
 * @property id The provider-assigned unique ID for this managed resource.
 * @property policy IAM bucket policy.
 */
public data class GetBucketPolicyResult(
    public val bucket: String,
    public val id: String,
    public val policy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.GetBucketPolicyResult):
            GetBucketPolicyResult = GetBucketPolicyResult(
            bucket = javaType.bucket(),
            id = javaType.id(),
            policy = javaType.policy(),
        )
    }
}
