@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getBucket.
 * @property arn ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
 * @property bucket
 * @property bucketDomainName Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
 * @property bucketRegionalDomainName The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/s3&#46;html#s3_region) for format&#46; Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin&#46; This will prevent redirect issues from CloudFront to the S3 Origin URL&#46; For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
 * @property hostedZoneId The [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property region AWS region this bucket resides in.
 * @property websiteDomain Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records.
 * @property websiteEndpoint Website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
 */
public data class GetBucketResult(
    public val arn: String,
    public val bucket: String,
    public val bucketDomainName: String,
    public val bucketRegionalDomainName: String,
    public val hostedZoneId: String,
    public val id: String,
    public val region: String,
    public val websiteDomain: String,
    public val websiteEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.GetBucketResult): GetBucketResult =
            GetBucketResult(
                arn = javaType.arn(),
                bucket = javaType.bucket(),
                bucketDomainName = javaType.bucketDomainName(),
                bucketRegionalDomainName = javaType.bucketRegionalDomainName(),
                hostedZoneId = javaType.hostedZoneId(),
                id = javaType.id(),
                region = javaType.region(),
                websiteDomain = javaType.websiteDomain(),
                websiteEndpoint = javaType.websiteEndpoint(),
            )
    }
}
