@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCanonicalUserId.
 * @property displayName Human-friendly name linked to the canonical user ID. The bucket owner's display name. **NOTE:** [This value](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTServiceGET.html) is only included in the response in the US East (N. Virginia), US West (N. California), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), EU (Ireland), and South America (São Paulo) regions.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetCanonicalUserIdResult(
    public val displayName: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.GetCanonicalUserIdResult):
            GetCanonicalUserIdResult = GetCanonicalUserIdResult(
            displayName = javaType.displayName(),
            id = javaType.id(),
        )
    }
}
