@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
 * @property bucketArn Amazon S3 bucket ARN of the destination.
 * @property encryption Contains the type of server-side encryption to use to encrypt the inventory (documented below).
 * @property format Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc&#46;apache&#46;org/) or [`Parquet`](https://parquet.apache.org/).
 * @property prefix Prefix that is prepended to all inventory results.
 */
public data class InventoryDestinationBucket(
    public val accountId: String? = null,
    public val bucketArn: String,
    public val encryption: InventoryDestinationBucketEncryption? = null,
    public val format: String,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.InventoryDestinationBucket):
            InventoryDestinationBucket = InventoryDestinationBucket(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            bucketArn = javaType.bucketArn(),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.InventoryDestinationBucketEncryption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            format = javaType.format(),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
