@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property email Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
 * @property id Canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
 * @property permissions List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
 * @property type Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
 * This configuration block has the following optional arguments (one of the three is required):
 * @property uri URI of the grantee group. Used only when `type` is `Group`.
 */
public data class ObjectCopyGrant(
    public val email: String? = null,
    public val id: String? = null,
    public val permissions: List<String>,
    public val type: String,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.ObjectCopyGrant): ObjectCopyGrant =
            ObjectCopyGrant(
                email = javaType.email().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                permissions = javaType.permissions().map({ args0 -> args0 }),
                type = javaType.type(),
                uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
            )
    }
}
