@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessGrantsInstanceResourcePolicy].
 */
@PulumiTagMarker
public class AccessGrantsInstanceResourcePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessGrantsInstanceResourcePolicyArgs = AccessGrantsInstanceResourcePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessGrantsInstanceResourcePolicyArgsBuilder.() -> Unit) {
        val builder = AccessGrantsInstanceResourcePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessGrantsInstanceResourcePolicy {
        val builtJavaResource =
            com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessGrantsInstanceResourcePolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Access Grants instance resource policy.
 * Use a resource policy to manage cross-account access to your S3 Access Grants instance.
 * ## Import
 * Using `pulumi import`, import S3 Access Grants instance resource policies using the `account_id`. For example:
 * ```sh
 *  $ pulumi import aws:s3control/accessGrantsInstanceResourcePolicy:AccessGrantsInstanceResourcePolicy example 123456789012
 * ```
 *
 */
public class AccessGrantsInstanceResourcePolicy internal constructor(
    override val javaResource: com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy,
) : KotlinCustomResource(javaResource, AccessGrantsInstanceResourcePolicyMapper) {
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The policy document.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object AccessGrantsInstanceResourcePolicyMapper :
    ResourceMapper<AccessGrantsInstanceResourcePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccessGrantsInstanceResourcePolicy =
        AccessGrantsInstanceResourcePolicy(
            javaResource as
                com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicy,
        )
}

/**
 * @see [AccessGrantsInstanceResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessGrantsInstanceResourcePolicy].
 */
public suspend fun accessGrantsInstanceResourcePolicy(
    name: String,
    block: suspend AccessGrantsInstanceResourcePolicyResourceBuilder.() -> Unit,
):
    AccessGrantsInstanceResourcePolicy {
    val builder = AccessGrantsInstanceResourcePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessGrantsInstanceResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessGrantsInstanceResourcePolicy(name: String): AccessGrantsInstanceResourcePolicy {
    val builder = AccessGrantsInstanceResourcePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
