@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Access Grants instance resource policy.
 * Use a resource policy to manage cross-account access to your S3 Access Grants instance.
 * ## Import
 * Using `pulumi import`, import S3 Access Grants instance resource policies using the `account_id`. For example:
 * ```sh
 *  $ pulumi import aws:s3control/accessGrantsInstanceResourcePolicy:AccessGrantsInstanceResourcePolicy example 123456789012
 * ```
 * @property accountId
 * @property policy The policy document.
 */
public data class AccessGrantsInstanceResourcePolicyArgs(
    public val accountId: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicyArgs =
        com.pulumi.aws.s3control.AccessGrantsInstanceResourcePolicyArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessGrantsInstanceResourcePolicyArgs].
 */
@PulumiTagMarker
public class AccessGrantsInstanceResourcePolicyArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rwukvjxyggunbgrr")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The policy document.
     */
    @JvmName("jkrxrjiwceuetfeg")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value
     */
    @JvmName("arjkktivicgxnfiw")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The policy document.
     */
    @JvmName("feyhbptodxjamsem")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): AccessGrantsInstanceResourcePolicyArgs =
        AccessGrantsInstanceResourcePolicyArgs(
            accountId = accountId,
            policy = policy,
        )
}
