@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessPointPolicy].
 */
@PulumiTagMarker
public class AccessPointPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPointPolicyArgs = AccessPointPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPointPolicyArgsBuilder.() -> Unit) {
        val builder = AccessPointPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessPointPolicy {
        val builtJavaResource = com.pulumi.aws.s3control.AccessPointPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessPointPolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Access Point resource policy.
 * > **NOTE on Access Points and Access Point Policies:** The provider provides both a standalone Access Point Policy resource and an Access Point resource with a resource policy defined in-line. You cannot use an Access Point with in-line resource policy in conjunction with an Access Point Policy resource. Doing so will cause a conflict of policies and will overwrite the access point's resource policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3.inputs.AccessPointPublicAccessBlockConfigurationArgs;
 * import com.pulumi.aws.s3control.AccessPointPolicy;
 * import com.pulumi.aws.s3control.AccessPointPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .publicAccessBlockConfiguration(AccessPointPublicAccessBlockConfigurationArgs.builder()
 *                 .blockPublicAcls(true)
 *                 .blockPublicPolicy(false)
 *                 .ignorePublicAcls(true)
 *                 .restrictPublicBuckets(false)
 *                 .build())
 *             .build());
 *         var exampleAccessPointPolicy = new AccessPointPolicy("exampleAccessPointPolicy", AccessPointPolicyArgs.builder()
 *             .accessPointArn(exampleAccessPoint.arn())
 *             .policy(exampleAccessPoint.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2008-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "s3:GetObjectTagging"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Resource", String.format("%s/object/*", arn))
 *                     )))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Access Point policies using the `access_point_arn`. For example:
 * ```sh
 *  $ pulumi import aws:s3control/accessPointPolicy:AccessPointPolicy example arn:aws:s3:us-west-2:123456789012:accesspoint/example
 * ```
 * */
 */
public class AccessPointPolicy internal constructor(
    override val javaResource: com.pulumi.aws.s3control.AccessPointPolicy,
) : KotlinCustomResource(javaResource, AccessPointPolicyMapper) {
    /**
     * The ARN of the access point that you want to associate with the specified policy.
     */
    public val accessPointArn: Output<String>
        get() = javaResource.accessPointArn().applyValue({ args0 -> args0 })

    /**
     * Indicates whether this access point currently has a policy that allows public access.
     */
    public val hasPublicAccessPolicy: Output<Boolean>
        get() = javaResource.hasPublicAccessPolicy().applyValue({ args0 -> args0 })

    /**
     * The policy that you want to apply to the specified access point.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object AccessPointPolicyMapper : ResourceMapper<AccessPointPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.AccessPointPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccessPointPolicy = AccessPointPolicy(
        javaResource as
            com.pulumi.aws.s3control.AccessPointPolicy,
    )
}

/**
 * @see [AccessPointPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPointPolicy].
 */
public suspend fun accessPointPolicy(
    name: String,
    block: suspend AccessPointPolicyResourceBuilder.() -> Unit,
): AccessPointPolicy {
    val builder = AccessPointPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPointPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPointPolicy(name: String): AccessPointPolicy {
    val builder = AccessPointPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
