@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.AccessPointPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Access Point resource policy.
 * > **NOTE on Access Points and Access Point Policies:** The provider provides both a standalone Access Point Policy resource and an Access Point resource with a resource policy defined in-line. You cannot use an Access Point with in-line resource policy in conjunction with an Access Point Policy resource. Doing so will cause a conflict of policies and will overwrite the access point's resource policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3.inputs.AccessPointPublicAccessBlockConfigurationArgs;
 * import com.pulumi.aws.s3control.AccessPointPolicy;
 * import com.pulumi.aws.s3control.AccessPointPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .publicAccessBlockConfiguration(AccessPointPublicAccessBlockConfigurationArgs.builder()
 *                 .blockPublicAcls(true)
 *                 .blockPublicPolicy(false)
 *                 .ignorePublicAcls(true)
 *                 .restrictPublicBuckets(false)
 *                 .build())
 *             .build());
 *         var exampleAccessPointPolicy = new AccessPointPolicy("exampleAccessPointPolicy", AccessPointPolicyArgs.builder()
 *             .accessPointArn(exampleAccessPoint.arn())
 *             .policy(exampleAccessPoint.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2008-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "s3:GetObjectTagging"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Resource", String.format("%s/object/*", arn))
 *                     )))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Access Point policies using the `access_point_arn`. For example:
 * ```sh
 *  $ pulumi import aws:s3control/accessPointPolicy:AccessPointPolicy example arn:aws:s3:us-west-2:123456789012:accesspoint/example
 * ```
 * @property accessPointArn The ARN of the access point that you want to associate with the specified policy.
 * @property policy The policy that you want to apply to the specified access point.
 * */
 */
public data class AccessPointPolicyArgs(
    public val accessPointArn: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.AccessPointPolicyArgs> {
    override fun toJava(): com.pulumi.aws.s3control.AccessPointPolicyArgs =
        com.pulumi.aws.s3control.AccessPointPolicyArgs.builder()
            .accessPointArn(accessPointArn?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPointPolicyArgs].
 */
@PulumiTagMarker
public class AccessPointPolicyArgsBuilder internal constructor() {
    private var accessPointArn: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The ARN of the access point that you want to associate with the specified policy.
     */
    @JvmName("ckwjiglawmhfjelt")
    public suspend fun accessPointArn(`value`: Output<String>) {
        this.accessPointArn = value
    }

    /**
     * @param value The policy that you want to apply to the specified access point.
     */
    @JvmName("pylgfneypjxkdmap")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ARN of the access point that you want to associate with the specified policy.
     */
    @JvmName("uiegjbaxtcsdjefr")
    public suspend fun accessPointArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPointArn = mapped
    }

    /**
     * @param value The policy that you want to apply to the specified access point.
     */
    @JvmName("ifbtfrjsndiagssq")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): AccessPointPolicyArgs = AccessPointPolicyArgs(
        accessPointArn = accessPointArn,
        policy = policy,
    )
}
