@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Bucket].
 */
@PulumiTagMarker
public class BucketResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketArgs = BucketArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketArgsBuilder.() -> Unit) {
        val builder = BucketArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Bucket {
        val builtJavaResource = com.pulumi.aws.s3control.Bucket(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Bucket(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Control Bucket.
 * > This functionality is for managing [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html). To manage S3 Buckets in an AWS Partition, see the `aws.s3.BucketV2` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.Bucket;
 * import com.pulumi.aws.s3control.BucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Bucket("example", BucketArgs.builder()
 *             .bucket("example")
 *             .outpostId(data.aws_outposts_outpost().example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Control Buckets using Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:s3control/bucket:Bucket example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-12345678/bucket/example
 * ```
 *
 */
public class Bucket internal constructor(
    override val javaResource: com.pulumi.aws.s3control.Bucket,
) : KotlinCustomResource(javaResource, BucketMapper) {
    /**
     * Amazon Resource Name (ARN) of the bucket.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * UTC creation date in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Identifier of the Outpost to contain this bucket.
     */
    public val outpostId: Output<String>
        get() = javaResource.outpostId().applyValue({ args0 -> args0 })

    /**
     * Boolean whether Public Access Block is enabled.
     */
    public val publicAccessBlockEnabled: Output<Boolean>
        get() = javaResource.publicAccessBlockEnabled().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object BucketMapper : ResourceMapper<Bucket> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.Bucket::class == javaResource::class

    override fun map(javaResource: Resource): Bucket = Bucket(
        javaResource as
            com.pulumi.aws.s3control.Bucket,
    )
}

/**
 * @see [Bucket].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bucket].
 */
public suspend fun bucket(name: String, block: suspend BucketResourceBuilder.() -> Unit): Bucket {
    val builder = BucketResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bucket].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucket(name: String): Bucket {
    val builder = BucketResourceBuilder()
    builder.name(name)
    return builder.build()
}
