@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.kotlin.outputs.BucketLifecycleConfigurationRule
import com.pulumi.aws.s3control.kotlin.outputs.BucketLifecycleConfigurationRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BucketLifecycleConfiguration].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketLifecycleConfigurationArgs = BucketLifecycleConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketLifecycleConfigurationArgsBuilder.() -> Unit) {
        val builder = BucketLifecycleConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketLifecycleConfiguration {
        val builtJavaResource =
            com.pulumi.aws.s3control.BucketLifecycleConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BucketLifecycleConfiguration(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Control Bucket Lifecycle Configuration.
 * > **NOTE:** Each S3 Control Bucket can only have one Lifecycle Configuration. Using multiple of this resource against the same S3 Control Bucket will result in perpetual differences each provider run.
 * > This functionality is for managing [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html). To manage S3 Bucket Lifecycle Configurations in an AWS Partition, see the `aws.s3.BucketV2` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.BucketLifecycleConfiguration;
 * import com.pulumi.aws.s3control.BucketLifecycleConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleExpirationArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfiguration("example", BucketLifecycleConfigurationArgs.builder()
 *             .bucket(aws_s3control_bucket.example().arn())
 *             .rules(
 *                 BucketLifecycleConfigurationRuleArgs.builder()
 *                     .expiration(BucketLifecycleConfigurationRuleExpirationArgs.builder()
 *                         .days(365)
 *                         .build())
 *                     .filter(BucketLifecycleConfigurationRuleFilterArgs.builder()
 *                         .prefix("logs/")
 *                         .build())
 *                     .id("logs")
 *                     .build(),
 *                 BucketLifecycleConfigurationRuleArgs.builder()
 *                     .expiration(BucketLifecycleConfigurationRuleExpirationArgs.builder()
 *                         .days(7)
 *                         .build())
 *                     .filter(BucketLifecycleConfigurationRuleFilterArgs.builder()
 *                         .prefix("temp/")
 *                         .build())
 *                     .id("temp")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Control Bucket Lifecycle Configurations using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:s3control/bucketLifecycleConfiguration:BucketLifecycleConfiguration example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-12345678/bucket/example
 * ```
 *
 */
public class BucketLifecycleConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.s3control.BucketLifecycleConfiguration,
) : KotlinCustomResource(javaResource, BucketLifecycleConfigurationMapper) {
    /**
     * Amazon Resource Name (ARN) of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Configuration block(s) containing lifecycle rules for the bucket.
     */
    public val rules: Output<List<BucketLifecycleConfigurationRule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object BucketLifecycleConfigurationMapper : ResourceMapper<BucketLifecycleConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.BucketLifecycleConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): BucketLifecycleConfiguration =
        BucketLifecycleConfiguration(
            javaResource as
                com.pulumi.aws.s3control.BucketLifecycleConfiguration,
        )
}

/**
 * @see [BucketLifecycleConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketLifecycleConfiguration].
 */
public suspend fun bucketLifecycleConfiguration(
    name: String,
    block: suspend BucketLifecycleConfigurationResourceBuilder.() -> Unit,
):
    BucketLifecycleConfiguration {
    val builder = BucketLifecycleConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketLifecycleConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketLifecycleConfiguration(name: String): BucketLifecycleConfiguration {
    val builder = BucketLifecycleConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
