@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.BucketLifecycleConfigurationArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.BucketLifecycleConfigurationRuleArgs
import com.pulumi.aws.s3control.kotlin.inputs.BucketLifecycleConfigurationRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Control Bucket Lifecycle Configuration.
 * > **NOTE:** Each S3 Control Bucket can only have one Lifecycle Configuration. Using multiple of this resource against the same S3 Control Bucket will result in perpetual differences each provider run.
 * > This functionality is for managing [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html). To manage S3 Bucket Lifecycle Configurations in an AWS Partition, see the `aws.s3.BucketV2` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.BucketLifecycleConfiguration;
 * import com.pulumi.aws.s3control.BucketLifecycleConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleExpirationArgs;
 * import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketLifecycleConfiguration("example", BucketLifecycleConfigurationArgs.builder()
 *             .bucket(aws_s3control_bucket.example().arn())
 *             .rules(
 *                 BucketLifecycleConfigurationRuleArgs.builder()
 *                     .expiration(BucketLifecycleConfigurationRuleExpirationArgs.builder()
 *                         .days(365)
 *                         .build())
 *                     .filter(BucketLifecycleConfigurationRuleFilterArgs.builder()
 *                         .prefix("logs/")
 *                         .build())
 *                     .id("logs")
 *                     .build(),
 *                 BucketLifecycleConfigurationRuleArgs.builder()
 *                     .expiration(BucketLifecycleConfigurationRuleExpirationArgs.builder()
 *                         .days(7)
 *                         .build())
 *                     .filter(BucketLifecycleConfigurationRuleFilterArgs.builder()
 *                         .prefix("temp/")
 *                         .build())
 *                     .id("temp")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Control Bucket Lifecycle Configurations using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:s3control/bucketLifecycleConfiguration:BucketLifecycleConfiguration example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-12345678/bucket/example
 * ```
 * @property bucket Amazon Resource Name (ARN) of the bucket.
 * @property rules Configuration block(s) containing lifecycle rules for the bucket.
 */
public data class BucketLifecycleConfigurationArgs(
    public val bucket: Output<String>? = null,
    public val rules: Output<List<BucketLifecycleConfigurationRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.BucketLifecycleConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.BucketLifecycleConfigurationArgs =
        com.pulumi.aws.s3control.BucketLifecycleConfigurationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketLifecycleConfigurationArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var rules: Output<List<BucketLifecycleConfigurationRuleArgs>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the bucket.
     */
    @JvmName("iadnpagbggfqxvls")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Configuration block(s) containing lifecycle rules for the bucket.
     */
    @JvmName("cufagxynhxgfklun")
    public suspend fun rules(`value`: Output<List<BucketLifecycleConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("kjkwkxpgxrpqnrqc")
    public suspend fun rules(vararg values: Output<BucketLifecycleConfigurationRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) containing lifecycle rules for the bucket.
     */
    @JvmName("tfaibwyhdjncltjn")
    public suspend fun rules(values: List<Output<BucketLifecycleConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the bucket.
     */
    @JvmName("lkmilobkkoaybuwa")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Configuration block(s) containing lifecycle rules for the bucket.
     */
    @JvmName("llgpprsmxdyijvbk")
    public suspend fun rules(`value`: List<BucketLifecycleConfigurationRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Configuration block(s) containing lifecycle rules for the bucket.
     */
    @JvmName("ikajbnrdgqgtppej")
    public suspend
    fun rules(argument: List<suspend BucketLifecycleConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Configuration block(s) containing lifecycle rules for the bucket.
     */
    @JvmName("uiqrntvrheuafhwc")
    public suspend fun rules(
        vararg
        argument: suspend BucketLifecycleConfigurationRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketLifecycleConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Configuration block(s) containing lifecycle rules for the bucket.
     */
    @JvmName("iciqefqmrrfhtjsb")
    public suspend
    fun rules(argument: suspend BucketLifecycleConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketLifecycleConfigurationRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Configuration block(s) containing lifecycle rules for the bucket.
     */
    @JvmName("rsoweyjohobkattv")
    public suspend fun rules(vararg values: BucketLifecycleConfigurationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): BucketLifecycleConfigurationArgs = BucketLifecycleConfigurationArgs(
        bucket = bucket,
        rules = rules,
    )
}
