@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketPolicy].
 */
@PulumiTagMarker
public class BucketPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketPolicyArgs = BucketPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketPolicyArgsBuilder.() -> Unit) {
        val builder = BucketPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketPolicy {
        val builtJavaResource = com.pulumi.aws.s3control.BucketPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketPolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Control Bucket Policy.
 * > This functionality is for managing [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html). To manage S3 Bucket Policies in an AWS Partition, see the `aws.s3.BucketPolicy` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.BucketPolicy;
 * import com.pulumi.aws.s3control.BucketPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketPolicy("example", BucketPolicyArgs.builder()
 *             .bucket(aws_s3control_bucket.example().arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Id", "testBucketPolicy"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "s3-outposts:PutBucketLifecycleConfiguration"),
 *                         jsonProperty("Effect", "Deny"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Resource", aws_s3control_bucket.example().arn()),
 *                         jsonProperty("Sid", "statement1")
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Control Bucket Policies using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:s3control/bucketPolicy:BucketPolicy example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-12345678/bucket/example
 * ```
 *
 */
public class BucketPolicy internal constructor(
    override val javaResource: com.pulumi.aws.s3control.BucketPolicy,
) : KotlinCustomResource(javaResource, BucketPolicyMapper) {
    /**
     * Amazon Resource Name (ARN) of the bucket.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * JSON string of the resource policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object BucketPolicyMapper : ResourceMapper<BucketPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.BucketPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BucketPolicy = BucketPolicy(
        javaResource as
            com.pulumi.aws.s3control.BucketPolicy,
    )
}

/**
 * @see [BucketPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketPolicy].
 */
public suspend fun bucketPolicy(
    name: String,
    block: suspend BucketPolicyResourceBuilder.() -> Unit,
): BucketPolicy {
    val builder = BucketPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketPolicy(name: String): BucketPolicy {
    val builder = BucketPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
