@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.BucketPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Control Bucket Policy.
 * > This functionality is for managing [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html). To manage S3 Bucket Policies in an AWS Partition, see the `aws.s3.BucketPolicy` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.BucketPolicy;
 * import com.pulumi.aws.s3control.BucketPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketPolicy("example", BucketPolicyArgs.builder()
 *             .bucket(aws_s3control_bucket.example().arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Id", "testBucketPolicy"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "s3-outposts:PutBucketLifecycleConfiguration"),
 *                         jsonProperty("Effect", "Deny"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Resource", aws_s3control_bucket.example().arn()),
 *                         jsonProperty("Sid", "statement1")
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Control Bucket Policies using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:s3control/bucketPolicy:BucketPolicy example arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-12345678/bucket/example
 * ```
 * @property bucket Amazon Resource Name (ARN) of the bucket.
 * @property policy JSON string of the resource policy.
 */
public data class BucketPolicyArgs(
    public val bucket: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.BucketPolicyArgs> {
    override fun toJava(): com.pulumi.aws.s3control.BucketPolicyArgs =
        com.pulumi.aws.s3control.BucketPolicyArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketPolicyArgs].
 */
@PulumiTagMarker
public class BucketPolicyArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the bucket.
     */
    @JvmName("mavxljqneyseyfab")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value JSON string of the resource policy.
     */
    @JvmName("kgjxhhrxgoibgxig")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the bucket.
     */
    @JvmName("orfklqaopckxcwyx")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value JSON string of the resource policy.
     */
    @JvmName("procudvnrvcccrcu")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): BucketPolicyArgs = BucketPolicyArgs(
        bucket = bucket,
        policy = policy,
    )
}
