@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.kotlin.outputs.MultiRegionAccessPointDetails
import com.pulumi.aws.s3control.kotlin.outputs.MultiRegionAccessPointDetails.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MultiRegionAccessPoint].
 */
@PulumiTagMarker
public class MultiRegionAccessPointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MultiRegionAccessPointArgs = MultiRegionAccessPointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MultiRegionAccessPointArgsBuilder.() -> Unit) {
        val builder = MultiRegionAccessPointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MultiRegionAccessPoint {
        val builtJavaResource = com.pulumi.aws.s3control.MultiRegionAccessPoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MultiRegionAccessPoint(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Multi-Region Access Point associated with specified buckets.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Multiple AWS Buckets in Different Regions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3control.MultiRegionAccessPoint;
 * import com.pulumi.aws.s3control.MultiRegionAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primaryRegion = new Provider("primaryRegion", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var secondaryRegion = new Provider("secondaryRegion", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         var fooBucket = new BucketV2("fooBucket", BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.primary_region())
 *             .build());
 *         var barBucket = new BucketV2("barBucket", BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.secondary_region())
 *             .build());
 *         var example = new MultiRegionAccessPoint("example", MultiRegionAccessPointArgs.builder()
 *             .details(MultiRegionAccessPointDetailsArgs.builder()
 *                 .name("example")
 *                 .regions(
 *                     MultiRegionAccessPointDetailsRegionArgs.builder()
 *                         .bucket(fooBucket.id())
 *                         .build(),
 *                     MultiRegionAccessPointDetailsRegionArgs.builder()
 *                         .bucket(barBucket.id())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Multi-Region Access Points using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:s3control/multiRegionAccessPoint:MultiRegionAccessPoint example 123456789012:example
 * ```
 *
 */
public class MultiRegionAccessPoint internal constructor(
    override val javaResource: com.pulumi.aws.s3control.MultiRegionAccessPoint,
) : KotlinCustomResource(javaResource, MultiRegionAccessPointMapper) {
    /**
     * The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The alias for the Multi-Region Access Point.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Multi-Region Access Point.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    public val details: Output<MultiRegionAccessPointDetails>
        get() = javaResource.details().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The DNS domain name of the S3 Multi-Region Access Point in the format _`alias`_.accesspoint.s3-global.amazonaws.com. For more information, see the documentation on [Multi-Region Access Point Requests](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRequests.html).
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The current status of the Multi-Region Access Point. One of: `READY`, `INCONSISTENT_ACROSS_REGIONS`, `CREATING`, `PARTIALLY_CREATED`, `PARTIALLY_DELETED`, `DELETING`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object MultiRegionAccessPointMapper : ResourceMapper<MultiRegionAccessPoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.MultiRegionAccessPoint::class == javaResource::class

    override fun map(javaResource: Resource): MultiRegionAccessPoint =
        MultiRegionAccessPoint(javaResource as com.pulumi.aws.s3control.MultiRegionAccessPoint)
}

/**
 * @see [MultiRegionAccessPoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MultiRegionAccessPoint].
 */
public suspend fun multiRegionAccessPoint(
    name: String,
    block: suspend MultiRegionAccessPointResourceBuilder.() -> Unit,
): MultiRegionAccessPoint {
    val builder = MultiRegionAccessPointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MultiRegionAccessPoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multiRegionAccessPoint(name: String): MultiRegionAccessPoint {
    val builder = MultiRegionAccessPointResourceBuilder()
    builder.name(name)
    return builder.build()
}
