@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.MultiRegionAccessPointArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.MultiRegionAccessPointDetailsArgs
import com.pulumi.aws.s3control.kotlin.inputs.MultiRegionAccessPointDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Multi-Region Access Point associated with specified buckets.
 * > This resource cannot be used with S3 directory buckets.
 * ## Example Usage
 * ### Multiple AWS Buckets in Different Regions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3control.MultiRegionAccessPoint;
 * import com.pulumi.aws.s3control.MultiRegionAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primaryRegion = new Provider("primaryRegion", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var secondaryRegion = new Provider("secondaryRegion", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         var fooBucket = new BucketV2("fooBucket", BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.primary_region())
 *             .build());
 *         var barBucket = new BucketV2("barBucket", BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.secondary_region())
 *             .build());
 *         var example = new MultiRegionAccessPoint("example", MultiRegionAccessPointArgs.builder()
 *             .details(MultiRegionAccessPointDetailsArgs.builder()
 *                 .name("example")
 *                 .regions(
 *                     MultiRegionAccessPointDetailsRegionArgs.builder()
 *                         .bucket(fooBucket.id())
 *                         .build(),
 *                     MultiRegionAccessPointDetailsRegionArgs.builder()
 *                         .bucket(barBucket.id())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Multi-Region Access Points using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:s3control/multiRegionAccessPoint:MultiRegionAccessPoint example 123456789012:example
 * ```
 * @property accountId The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
 * @property details A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
 */
public data class MultiRegionAccessPointArgs(
    public val accountId: Output<String>? = null,
    public val details: Output<MultiRegionAccessPointDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.MultiRegionAccessPointArgs> {
    override fun toJava(): com.pulumi.aws.s3control.MultiRegionAccessPointArgs =
        com.pulumi.aws.s3control.MultiRegionAccessPointArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .details(details?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MultiRegionAccessPointArgs].
 */
@PulumiTagMarker
public class MultiRegionAccessPointArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var details: Output<MultiRegionAccessPointDetailsArgs>? = null

    /**
     * @param value The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("mcewdgyywegerhhv")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("gqxmqrttjudavwrt")
    public suspend fun details(`value`: Output<MultiRegionAccessPointDetailsArgs>) {
        this.details = value
    }

    /**
     * @param value The AWS account ID for the owner of the buckets for which you want to create a Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("vphpsjabfriovfhg")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("fyixwemivmwvjiwk")
    public suspend fun details(`value`: MultiRegionAccessPointDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param argument A configuration block containing details about the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("bgkaflcnmdchecdj")
    public suspend
    fun details(argument: suspend MultiRegionAccessPointDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = MultiRegionAccessPointDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    internal fun build(): MultiRegionAccessPointArgs = MultiRegionAccessPointArgs(
        accountId = accountId,
        details = details,
    )
}
