@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.MultiRegionAccessPointPolicyDetailsArgs
import com.pulumi.aws.s3control.kotlin.inputs.MultiRegionAccessPointPolicyDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Multi-Region Access Point access control policy.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3control.MultiRegionAccessPoint;
 * import com.pulumi.aws.s3control.MultiRegionAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs;
 * import com.pulumi.aws.s3control.MultiRegionAccessPointPolicy;
 * import com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs;
 * import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointPolicyDetailsArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         var fooBucket = new BucketV2("fooBucket");
 *         var exampleMultiRegionAccessPoint = new MultiRegionAccessPoint("exampleMultiRegionAccessPoint", MultiRegionAccessPointArgs.builder()
 *             .details(MultiRegionAccessPointDetailsArgs.builder()
 *                 .name("example")
 *                 .regions(MultiRegionAccessPointDetailsRegionArgs.builder()
 *                     .bucket(fooBucket.id())
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleMultiRegionAccessPointPolicy = new MultiRegionAccessPointPolicy("exampleMultiRegionAccessPointPolicy", MultiRegionAccessPointPolicyArgs.builder()
 *             .details(MultiRegionAccessPointPolicyDetailsArgs.builder()
 *                 .name(exampleMultiRegionAccessPoint.id().applyValue(id -> id.split(":"))[1])
 *                 .policy(exampleMultiRegionAccessPoint.alias().applyValue(alias -> serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Version", "2012-10-17"),
 *                         jsonProperty("Statement", jsonArray(jsonObject(
 *                             jsonProperty("Sid", "Example"),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("AWS", currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                             )),
 *                             jsonProperty("Action", jsonArray(
 *                                 "s3:GetObject",
 *                                 "s3:PutObject"
 *                             )),
 *                             jsonProperty("Resource", String.format("arn:%s:s3::%s:accesspoint/%s/object/*", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),alias))
 *                         )))
 *                     ))))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Multi-Region Access Point Policies using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:s3control/multiRegionAccessPointPolicy:MultiRegionAccessPointPolicy example 123456789012:example
 * ```
 * @property accountId The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
 * @property details A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
 * */
 */
public data class MultiRegionAccessPointPolicyArgs(
    public val accountId: Output<String>? = null,
    public val details: Output<MultiRegionAccessPointPolicyDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs> {
    override fun toJava(): com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs =
        com.pulumi.aws.s3control.MultiRegionAccessPointPolicyArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .details(details?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MultiRegionAccessPointPolicyArgs].
 */
@PulumiTagMarker
public class MultiRegionAccessPointPolicyArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var details: Output<MultiRegionAccessPointPolicyDetailsArgs>? = null

    /**
     * @param value The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("jmwyiqmwbdqdcvlw")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("buejhmweeexactwu")
    public suspend fun details(`value`: Output<MultiRegionAccessPointPolicyDetailsArgs>) {
        this.details = value
    }

    /**
     * @param value The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("jeaokbgxacuiuitn")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("hqveeodnrmudubjn")
    public suspend fun details(`value`: MultiRegionAccessPointPolicyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param argument A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
     */
    @JvmName("gexwnnqjjlxsolru")
    public suspend
    fun details(argument: suspend MultiRegionAccessPointPolicyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = MultiRegionAccessPointPolicyDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    internal fun build(): MultiRegionAccessPointPolicyArgs = MultiRegionAccessPointPolicyArgs(
        accountId = accountId,
        details = details,
    )
}
