@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.kotlin.outputs.ObjectLambdaAccessPointConfiguration
import com.pulumi.aws.s3control.kotlin.outputs.ObjectLambdaAccessPointConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ObjectLambdaAccessPoint].
 */
@PulumiTagMarker
public class ObjectLambdaAccessPointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ObjectLambdaAccessPointArgs = ObjectLambdaAccessPointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ObjectLambdaAccessPointArgsBuilder.() -> Unit) {
        val builder = ObjectLambdaAccessPointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ObjectLambdaAccessPoint {
        val builtJavaResource =
            com.pulumi.aws.s3control.ObjectLambdaAccessPoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ObjectLambdaAccessPoint(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Object Lambda Access Point.
 * An Object Lambda access point is associated with exactly one standard access point and thus one Amazon S3 bucket.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPoint;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .build());
 *         var exampleObjectLambdaAccessPoint = new ObjectLambdaAccessPoint("exampleObjectLambdaAccessPoint", ObjectLambdaAccessPointArgs.builder()
 *             .configuration(ObjectLambdaAccessPointConfigurationArgs.builder()
 *                 .supportingAccessPoint(exampleAccessPoint.arn())
 *                 .transformationConfigurations(ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs.builder()
 *                     .actions("GetObject")
 *                     .contentTransformation(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs.builder()
 *                         .awsLambda(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs.builder()
 *                             .functionArn(aws_lambda_function.example().arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Object Lambda Access Points using the `account_id` and `name`, separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:s3control/objectLambdaAccessPoint:ObjectLambdaAccessPoint example 123456789012:example
 * ```
 *
 */
public class ObjectLambdaAccessPoint internal constructor(
    override val javaResource: com.pulumi.aws.s3control.ObjectLambdaAccessPoint,
) : KotlinCustomResource(javaResource, ObjectLambdaAccessPointMapper) {
    /**
     * The AWS account ID for the owner of the bucket for which you want to create an Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Alias for the S3 Object Lambda Access Point.
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Object Lambda Access Point.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
     */
    public val configuration: Output<ObjectLambdaAccessPointConfiguration>
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The name for this Object Lambda Access Point.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ObjectLambdaAccessPointMapper : ResourceMapper<ObjectLambdaAccessPoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.ObjectLambdaAccessPoint::class == javaResource::class

    override fun map(javaResource: Resource): ObjectLambdaAccessPoint =
        ObjectLambdaAccessPoint(javaResource as com.pulumi.aws.s3control.ObjectLambdaAccessPoint)
}

/**
 * @see [ObjectLambdaAccessPoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ObjectLambdaAccessPoint].
 */
public suspend fun objectLambdaAccessPoint(
    name: String,
    block: suspend ObjectLambdaAccessPointResourceBuilder.() -> Unit,
): ObjectLambdaAccessPoint {
    val builder = ObjectLambdaAccessPointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ObjectLambdaAccessPoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun objectLambdaAccessPoint(name: String): ObjectLambdaAccessPoint {
    val builder = ObjectLambdaAccessPointResourceBuilder()
    builder.name(name)
    return builder.build()
}
