@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.ObjectLambdaAccessPointConfigurationArgs
import com.pulumi.aws.s3control.kotlin.inputs.ObjectLambdaAccessPointConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Object Lambda Access Point.
 * An Object Lambda access point is associated with exactly one standard access point and thus one Amazon S3 bucket.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPoint;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .build());
 *         var exampleObjectLambdaAccessPoint = new ObjectLambdaAccessPoint("exampleObjectLambdaAccessPoint", ObjectLambdaAccessPointArgs.builder()
 *             .configuration(ObjectLambdaAccessPointConfigurationArgs.builder()
 *                 .supportingAccessPoint(exampleAccessPoint.arn())
 *                 .transformationConfigurations(ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs.builder()
 *                     .actions("GetObject")
 *                     .contentTransformation(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs.builder()
 *                         .awsLambda(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs.builder()
 *                             .functionArn(aws_lambda_function.example().arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Object Lambda Access Points using the `account_id` and `name`, separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:s3control/objectLambdaAccessPoint:ObjectLambdaAccessPoint example 123456789012:example
 * ```
 * @property accountId The AWS account ID for the owner of the bucket for which you want to create an Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
 * @property configuration A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
 * @property name The name for this Object Lambda Access Point.
 */
public data class ObjectLambdaAccessPointArgs(
    public val accountId: Output<String>? = null,
    public val configuration: Output<ObjectLambdaAccessPointConfigurationArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs> {
    override fun toJava(): com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs =
        com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObjectLambdaAccessPointArgs].
 */
@PulumiTagMarker
public class ObjectLambdaAccessPointArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var configuration: Output<ObjectLambdaAccessPointConfigurationArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The AWS account ID for the owner of the bucket for which you want to create an Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("ffyqnerejlclhwfv")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
     */
    @JvmName("kxwkeyeloasipeew")
    public suspend fun configuration(`value`: Output<ObjectLambdaAccessPointConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value The name for this Object Lambda Access Point.
     */
    @JvmName("leluspcsrwdbmuuy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The AWS account ID for the owner of the bucket for which you want to create an Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("jqoegtdwhngnxjss")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
     */
    @JvmName("liygehdgpigyrjmb")
    public suspend fun configuration(`value`: ObjectLambdaAccessPointConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument A configuration block containing details about the Object Lambda Access Point. See Configuration below for more details.
     */
    @JvmName("lnecditvkajujfin")
    public suspend
    fun configuration(argument: suspend ObjectLambdaAccessPointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ObjectLambdaAccessPointConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value The name for this Object Lambda Access Point.
     */
    @JvmName("evvcsswbptaiyogm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ObjectLambdaAccessPointArgs = ObjectLambdaAccessPointArgs(
        accountId = accountId,
        configuration = configuration,
        name = name,
    )
}
