@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ObjectLambdaAccessPointPolicy].
 */
@PulumiTagMarker
public class ObjectLambdaAccessPointPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ObjectLambdaAccessPointPolicyArgs = ObjectLambdaAccessPointPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ObjectLambdaAccessPointPolicyArgsBuilder.() -> Unit) {
        val builder = ObjectLambdaAccessPointPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ObjectLambdaAccessPointPolicy {
        val builtJavaResource =
            com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ObjectLambdaAccessPointPolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Object Lambda Access Point resource policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.AccessPoint;
 * import com.pulumi.aws.s3.AccessPointArgs;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPoint;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointArgs;
 * import com.pulumi.aws.s3control.inputs.ObjectLambdaAccessPointConfigurationArgs;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy;
 * import com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleAccessPoint = new AccessPoint("exampleAccessPoint", AccessPointArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .build());
 *         var exampleObjectLambdaAccessPoint = new ObjectLambdaAccessPoint("exampleObjectLambdaAccessPoint", ObjectLambdaAccessPointArgs.builder()
 *             .configuration(ObjectLambdaAccessPointConfigurationArgs.builder()
 *                 .supportingAccessPoint(exampleAccessPoint.arn())
 *                 .transformationConfigurations(ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs.builder()
 *                     .actions("GetObject")
 *                     .contentTransformation(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs.builder()
 *                         .awsLambda(ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs.builder()
 *                             .functionArn(aws_lambda_function.example().arn())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleObjectLambdaAccessPointPolicy = new ObjectLambdaAccessPointPolicy("exampleObjectLambdaAccessPointPolicy", ObjectLambdaAccessPointPolicyArgs.builder()
 *             .policy(exampleObjectLambdaAccessPoint.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2008-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "s3-object-lambda:GetObject"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", data.aws_caller_identity().current().account_id())
 *                         )),
 *                         jsonProperty("Resource", arn)
 *                     )))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Object Lambda Access Point policies using the `account_id` and `name`, separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:s3control/objectLambdaAccessPointPolicy:ObjectLambdaAccessPointPolicy example 123456789012:example
 * ```
 *
 */
public class ObjectLambdaAccessPointPolicy internal constructor(
    override val javaResource: com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy,
) : KotlinCustomResource(javaResource, ObjectLambdaAccessPointPolicyMapper) {
    /**
     * The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether this access point currently has a policy that allows public access.
     */
    public val hasPublicAccessPolicy: Output<Boolean>
        get() = javaResource.hasPublicAccessPolicy().applyValue({ args0 -> args0 })

    /**
     * The name of the Object Lambda Access Point.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Object Lambda Access Point resource policy document.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object ObjectLambdaAccessPointPolicyMapper : ResourceMapper<ObjectLambdaAccessPointPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ObjectLambdaAccessPointPolicy =
        ObjectLambdaAccessPointPolicy(
            javaResource as
                com.pulumi.aws.s3control.ObjectLambdaAccessPointPolicy,
        )
}

/**
 * @see [ObjectLambdaAccessPointPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ObjectLambdaAccessPointPolicy].
 */
public suspend fun objectLambdaAccessPointPolicy(
    name: String,
    block: suspend ObjectLambdaAccessPointPolicyResourceBuilder.() -> Unit,
):
    ObjectLambdaAccessPointPolicy {
    val builder = ObjectLambdaAccessPointPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ObjectLambdaAccessPointPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun objectLambdaAccessPointPolicy(name: String): ObjectLambdaAccessPointPolicy {
    val builder = ObjectLambdaAccessPointPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
