@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.S3controlFunctions.getMultiRegionAccessPointPlain
import com.pulumi.aws.s3control.kotlin.inputs.GetMultiRegionAccessPointPlainArgs
import com.pulumi.aws.s3control.kotlin.inputs.GetMultiRegionAccessPointPlainArgsBuilder
import com.pulumi.aws.s3control.kotlin.outputs.GetMultiRegionAccessPointResult
import com.pulumi.aws.s3control.kotlin.outputs.GetMultiRegionAccessPointResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object S3controlFunctions {
    /**
     * Provides details on a specific S3 Multi-Region Access Point.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3control.S3controlFunctions;
     * import com.pulumi.aws.s3control.inputs.GetMultiRegionAccessPointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = S3controlFunctions.getMultiRegionAccessPoint(GetMultiRegionAccessPointArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getMultiRegionAccessPoint.
     * @return A collection of values returned by getMultiRegionAccessPoint.
     */
    public suspend fun getMultiRegionAccessPoint(argument: GetMultiRegionAccessPointPlainArgs):
        GetMultiRegionAccessPointResult =
        toKotlin(getMultiRegionAccessPointPlain(argument.toJava()).await())

    /**
     * @see [getMultiRegionAccessPoint].
     * @param accountId The AWS account ID of the S3 Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     * @param name The name of the Multi-Region Access Point.
     * @return A collection of values returned by getMultiRegionAccessPoint.
     */
    public suspend fun getMultiRegionAccessPoint(accountId: String? = null, name: String):
        GetMultiRegionAccessPointResult {
        val argument = GetMultiRegionAccessPointPlainArgs(
            accountId = accountId,
            name = name,
        )
        return toKotlin(getMultiRegionAccessPointPlain(argument.toJava()).await())
    }

    /**
     * @see [getMultiRegionAccessPoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;s3control&#46;kotlin&#46;inputs&#46;GetMultiRegionAccessPointPlainArgs].
     * @return A collection of values returned by getMultiRegionAccessPoint.
     */
    public suspend
    fun getMultiRegionAccessPoint(argument: suspend GetMultiRegionAccessPointPlainArgsBuilder.() -> Unit):
        GetMultiRegionAccessPointResult {
        val builder = GetMultiRegionAccessPointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getMultiRegionAccessPointPlain(builtArgument.toJava()).await())
    }
}
