@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfiguration
import com.pulumi.aws.s3control.kotlin.outputs.StorageLensConfigurationStorageLensConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [StorageLensConfiguration].
 */
@PulumiTagMarker
public class StorageLensConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageLensConfigurationArgs = StorageLensConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageLensConfigurationArgsBuilder.() -> Unit) {
        val builder = StorageLensConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StorageLensConfiguration {
        val builtJavaResource =
            com.pulumi.aws.s3control.StorageLensConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageLensConfiguration(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Storage Lens configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.s3control.StorageLensConfiguration;
 * import com.pulumi.aws.s3control.StorageLensConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationExcludeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new StorageLensConfiguration("example", StorageLensConfigurationArgs.builder()
 *             .configId("example-1")
 *             .storageLensConfiguration(StorageLensConfigurationStorageLensConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .accountLevel(StorageLensConfigurationStorageLensConfigurationAccountLevelArgs.builder()
 *                     .activityMetrics(StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .bucketLevel(StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs.builder()
 *                         .activityMetrics(StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs.builder()
 *                             .enabled(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .dataExport(StorageLensConfigurationStorageLensConfigurationDataExportArgs.builder()
 *                     .cloudWatchMetrics(StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .s3BucketDestination(StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs.builder()
 *                         .accountId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .arn(aws_s3_bucket.target().arn())
 *                         .format("CSV")
 *                         .outputSchemaVersion("V_1")
 *                         .encryption(StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs.builder()
 *                             .sseS3s()
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .exclude(StorageLensConfigurationStorageLensConfigurationExcludeArgs.builder()
 *                     .buckets(
 *                         aws_s3_bucket.b1().arn(),
 *                         aws_s3_bucket.b2().arn())
 *                     .regions("us-east-2")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Storage Lens configurations using the `account_id` and `config_id`, separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:s3control/storageLensConfiguration:StorageLensConfiguration example 123456789012:example-1
 * ```
 *
 */
public class StorageLensConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.s3control.StorageLensConfiguration,
) : KotlinCustomResource(javaResource, StorageLensConfigurationMapper) {
    /**
     * The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services organization.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the S3 Storage Lens configuration.
     */
    public val configId: Output<String>
        get() = javaResource.configId().applyValue({ args0 -> args0 })

    /**
     * The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
     */
    public val storageLensConfiguration: Output<StorageLensConfigurationStorageLensConfiguration>
        get() = javaResource.storageLensConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object StorageLensConfigurationMapper : ResourceMapper<StorageLensConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.StorageLensConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): StorageLensConfiguration =
        StorageLensConfiguration(javaResource as com.pulumi.aws.s3control.StorageLensConfiguration)
}

/**
 * @see [StorageLensConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageLensConfiguration].
 */
public suspend fun storageLensConfiguration(
    name: String,
    block: suspend StorageLensConfigurationResourceBuilder.() -> Unit,
): StorageLensConfiguration {
    val builder = StorageLensConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageLensConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageLensConfiguration(name: String): StorageLensConfiguration {
    val builder = StorageLensConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
