@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.StorageLensConfigurationArgs.builder
import com.pulumi.aws.s3control.kotlin.inputs.StorageLensConfigurationStorageLensConfigurationArgs
import com.pulumi.aws.s3control.kotlin.inputs.StorageLensConfigurationStorageLensConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an S3 Storage Lens configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.s3control.StorageLensConfiguration;
 * import com.pulumi.aws.s3control.StorageLensConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs;
 * import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationExcludeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new StorageLensConfiguration("example", StorageLensConfigurationArgs.builder()
 *             .configId("example-1")
 *             .storageLensConfiguration(StorageLensConfigurationStorageLensConfigurationArgs.builder()
 *                 .enabled(true)
 *                 .accountLevel(StorageLensConfigurationStorageLensConfigurationAccountLevelArgs.builder()
 *                     .activityMetrics(StorageLensConfigurationStorageLensConfigurationAccountLevelActivityMetricsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .bucketLevel(StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelArgs.builder()
 *                         .activityMetrics(StorageLensConfigurationStorageLensConfigurationAccountLevelBucketLevelActivityMetricsArgs.builder()
 *                             .enabled(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .dataExport(StorageLensConfigurationStorageLensConfigurationDataExportArgs.builder()
 *                     .cloudWatchMetrics(StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .s3BucketDestination(StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs.builder()
 *                         .accountId(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .arn(aws_s3_bucket.target().arn())
 *                         .format("CSV")
 *                         .outputSchemaVersion("V_1")
 *                         .encryption(StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs.builder()
 *                             .sseS3s()
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .exclude(StorageLensConfigurationStorageLensConfigurationExcludeArgs.builder()
 *                     .buckets(
 *                         aws_s3_bucket.b1().arn(),
 *                         aws_s3_bucket.b2().arn())
 *                     .regions("us-east-2")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import S3 Storage Lens configurations using the `account_id` and `config_id`, separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:s3control/storageLensConfiguration:StorageLensConfiguration example 123456789012:example-1
 * ```
 * @property accountId The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
 * @property configId The ID of the S3 Storage Lens configuration.
 * @property storageLensConfiguration The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class StorageLensConfigurationArgs(
    public val accountId: Output<String>? = null,
    public val configId: Output<String>? = null,
    public val storageLensConfiguration: Output<StorageLensConfigurationStorageLensConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3control.StorageLensConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3control.StorageLensConfigurationArgs =
        com.pulumi.aws.s3control.StorageLensConfigurationArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .configId(configId?.applyValue({ args0 -> args0 }))
            .storageLensConfiguration(
                storageLensConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageLensConfigurationArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var configId: Output<String>? = null

    private var storageLensConfiguration:
        Output<StorageLensConfigurationStorageLensConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("lftdjorlwjivavii")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The ID of the S3 Storage Lens configuration.
     */
    @JvmName("acgascrvoqvvxxre")
    public suspend fun configId(`value`: Output<String>) {
        this.configId = value
    }

    /**
     * @param value The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
     */
    @JvmName("exftvlseeytvlero")
    public suspend
    fun storageLensConfiguration(`value`: Output<StorageLensConfigurationStorageLensConfigurationArgs>) {
        this.storageLensConfiguration = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gnmdvmrisokfgctx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The AWS account ID for the S3 Storage Lens configuration. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("nibhtqymxdectdow")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The ID of the S3 Storage Lens configuration.
     */
    @JvmName("qytjdrwsrnomqdoj")
    public suspend fun configId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configId = mapped
    }

    /**
     * @param value The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
     */
    @JvmName("uyyyeysncarhrwtr")
    public suspend
    fun storageLensConfiguration(`value`: StorageLensConfigurationStorageLensConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLensConfiguration = mapped
    }

    /**
     * @param argument The S3 Storage Lens configuration. See Storage Lens Configuration below for more details.
     */
    @JvmName("hhbivibvxrgjcofw")
    public suspend
    fun storageLensConfiguration(argument: suspend StorageLensConfigurationStorageLensConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageLensConfigurationStorageLensConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageLensConfiguration = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vcguhxfunplqdedj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aqbxmqkgkayrmnyt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageLensConfigurationArgs = StorageLensConfigurationArgs(
        accountId = accountId,
        configId = configId,
        storageLensConfiguration = storageLensConfiguration,
        tags = tags,
    )
}
