@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property daysAfterInitiation Number of days after which Amazon S3 aborts an incomplete multipart upload.
 */
public data class BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs(
    public val daysAfterInitiation: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs> {
    override fun toJava():
        com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs =
        com.pulumi.aws.s3control.inputs.BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs.builder()
            .daysAfterInitiation(daysAfterInitiation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs].
 */
@PulumiTagMarker
public class BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgsBuilder internal
constructor() {
    private var daysAfterInitiation: Output<Int>? = null

    /**
     * @param value Number of days after which Amazon S3 aborts an incomplete multipart upload.
     */
    @JvmName("topcxsyvkvisknqv")
    public suspend fun daysAfterInitiation(`value`: Output<Int>) {
        this.daysAfterInitiation = value
    }

    /**
     * @param value Number of days after which Amazon S3 aborts an incomplete multipart upload.
     */
    @JvmName("jsdtcxjsmgodwjsw")
    public suspend fun daysAfterInitiation(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysAfterInitiation = mapped
    }

    internal fun build(): BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs =
        BucketLifecycleConfigurationRuleAbortIncompleteMultipartUploadArgs(
            daysAfterInitiation = daysAfterInitiation ?: throw PulumiNullFieldException("daysAfterInitiation"),
        )
}
