@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.GetMultiRegionAccessPointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMultiRegionAccessPoint.
 * @property accountId The AWS account ID of the S3 Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
 * @property name The name of the Multi-Region Access Point.
 */
public data class GetMultiRegionAccessPointPlainArgs(
    public val accountId: String? = null,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.s3control.inputs.GetMultiRegionAccessPointPlainArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.GetMultiRegionAccessPointPlainArgs =
        com.pulumi.aws.s3control.inputs.GetMultiRegionAccessPointPlainArgs.builder()
            .accountId(accountId?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMultiRegionAccessPointPlainArgs].
 */
@PulumiTagMarker
public class GetMultiRegionAccessPointPlainArgsBuilder internal constructor() {
    private var accountId: String? = null

    private var name: String? = null

    /**
     * @param value The AWS account ID of the S3 Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("apkexkwoqpyjdodh")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accountId = mapped
    }

    /**
     * @param value The name of the Multi-Region Access Point.
     */
    @JvmName("almrtadkwndgffwv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetMultiRegionAccessPointPlainArgs = GetMultiRegionAccessPointPlainArgs(
        accountId = accountId,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
