@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name
 * @property publicAccessBlock
 * @property regions
 */
public data class MultiRegionAccessPointDetailsArgs(
    public val name: Output<String>,
    public val publicAccessBlock: Output<MultiRegionAccessPointDetailsPublicAccessBlockArgs>? = null,
    public val regions: Output<List<MultiRegionAccessPointDetailsRegionArgs>>,
) : ConvertibleToJava<com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs =
        com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .publicAccessBlock(publicAccessBlock?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regions(
                regions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MultiRegionAccessPointDetailsArgs].
 */
@PulumiTagMarker
public class MultiRegionAccessPointDetailsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var publicAccessBlock: Output<MultiRegionAccessPointDetailsPublicAccessBlockArgs>? = null

    private var regions: Output<List<MultiRegionAccessPointDetailsRegionArgs>>? = null

    /**
     * @param value
     */
    @JvmName("kfvxljxbpctjqamu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("rvmkequevgyrnqoi")
    public suspend
    fun publicAccessBlock(`value`: Output<MultiRegionAccessPointDetailsPublicAccessBlockArgs>) {
        this.publicAccessBlock = value
    }

    /**
     * @param value
     */
    @JvmName("odudujkeiipnpauq")
    public suspend fun regions(`value`: Output<List<MultiRegionAccessPointDetailsRegionArgs>>) {
        this.regions = value
    }

    @JvmName("yqnkjkoqgdmssvcb")
    public suspend fun regions(vararg values: Output<MultiRegionAccessPointDetailsRegionArgs>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xwywldmhncnmgdwm")
    public suspend fun regions(values: List<Output<MultiRegionAccessPointDetailsRegionArgs>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("pkvucnqshmypvcrq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("niptdngkmqkgreyo")
    public suspend
    fun publicAccessBlock(`value`: MultiRegionAccessPointDetailsPublicAccessBlockArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicAccessBlock = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hgreejcvepgfebit")
    public suspend
    fun publicAccessBlock(argument: suspend MultiRegionAccessPointDetailsPublicAccessBlockArgsBuilder.() -> Unit) {
        val toBeMapped = MultiRegionAccessPointDetailsPublicAccessBlockArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicAccessBlock = mapped
    }

    /**
     * @param value
     */
    @JvmName("yjhgsdifcjkujehs")
    public suspend fun regions(`value`: List<MultiRegionAccessPointDetailsRegionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ipkwstpdulbohkbk")
    public suspend
    fun regions(argument: List<suspend MultiRegionAccessPointDetailsRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MultiRegionAccessPointDetailsRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ldwnlepgbweeoard")
    public suspend fun regions(
        vararg
        argument: suspend MultiRegionAccessPointDetailsRegionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MultiRegionAccessPointDetailsRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xlycpcxlhorrkrxi")
    public suspend
    fun regions(argument: suspend MultiRegionAccessPointDetailsRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MultiRegionAccessPointDetailsRegionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param values
     */
    @JvmName("dimakjtuahettsgu")
    public suspend fun regions(vararg values: MultiRegionAccessPointDetailsRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    internal fun build(): MultiRegionAccessPointDetailsArgs = MultiRegionAccessPointDetailsArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        publicAccessBlock = publicAccessBlock,
        regions = regions ?: throw PulumiNullFieldException("regions"),
    )
}
