@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsPublicAccessBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blockPublicAcls
 * @property blockPublicPolicy
 * @property ignorePublicAcls
 * @property restrictPublicBuckets
 */
public data class MultiRegionAccessPointDetailsPublicAccessBlockArgs(
    public val blockPublicAcls: Output<Boolean>? = null,
    public val blockPublicPolicy: Output<Boolean>? = null,
    public val ignorePublicAcls: Output<Boolean>? = null,
    public val restrictPublicBuckets: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsPublicAccessBlockArgs> {
    override fun toJava():
        com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsPublicAccessBlockArgs =
        com.pulumi.aws.s3control.inputs.MultiRegionAccessPointDetailsPublicAccessBlockArgs.builder()
            .blockPublicAcls(blockPublicAcls?.applyValue({ args0 -> args0 }))
            .blockPublicPolicy(blockPublicPolicy?.applyValue({ args0 -> args0 }))
            .ignorePublicAcls(ignorePublicAcls?.applyValue({ args0 -> args0 }))
            .restrictPublicBuckets(restrictPublicBuckets?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultiRegionAccessPointDetailsPublicAccessBlockArgs].
 */
@PulumiTagMarker
public class MultiRegionAccessPointDetailsPublicAccessBlockArgsBuilder internal constructor() {
    private var blockPublicAcls: Output<Boolean>? = null

    private var blockPublicPolicy: Output<Boolean>? = null

    private var ignorePublicAcls: Output<Boolean>? = null

    private var restrictPublicBuckets: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("nkrenfiltcoeyhox")
    public suspend fun blockPublicAcls(`value`: Output<Boolean>) {
        this.blockPublicAcls = value
    }

    /**
     * @param value
     */
    @JvmName("hbyrveqfjavsxtuq")
    public suspend fun blockPublicPolicy(`value`: Output<Boolean>) {
        this.blockPublicPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("sjcrgkxdedodxuch")
    public suspend fun ignorePublicAcls(`value`: Output<Boolean>) {
        this.ignorePublicAcls = value
    }

    /**
     * @param value
     */
    @JvmName("khxxwmtenetjnpbj")
    public suspend fun restrictPublicBuckets(`value`: Output<Boolean>) {
        this.restrictPublicBuckets = value
    }

    /**
     * @param value
     */
    @JvmName("ravtuaqbstnowacx")
    public suspend fun blockPublicAcls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicAcls = mapped
    }

    /**
     * @param value
     */
    @JvmName("cocmfmhcmboyisot")
    public suspend fun blockPublicPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("epblkmqyhldnsgri")
    public suspend fun ignorePublicAcls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignorePublicAcls = mapped
    }

    /**
     * @param value
     */
    @JvmName("sxebfgvoychliffs")
    public suspend fun restrictPublicBuckets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictPublicBuckets = mapped
    }

    internal fun build(): MultiRegionAccessPointDetailsPublicAccessBlockArgs =
        MultiRegionAccessPointDetailsPublicAccessBlockArgs(
            blockPublicAcls = blockPublicAcls,
            blockPublicPolicy = blockPublicPolicy,
            ignorePublicAcls = ignorePublicAcls,
            restrictPublicBuckets = restrictPublicBuckets,
        )
}
