@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.MultiRegionAccessPointPolicyDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the Multi-Region Access Point.
 * @property policy A valid JSON document that specifies the policy that you want to associate with this Multi-Region Access Point. Once applied, the policy can be edited, but not deleted. For more information, see the documentation on [Multi-Region Access Point Permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointPermissions.html).
 * > **NOTE:** When you update the `policy`, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.
 */
public data class MultiRegionAccessPointPolicyDetailsArgs(
    public val name: Output<String>,
    public val policy: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3control.inputs.MultiRegionAccessPointPolicyDetailsArgs> {
    override fun toJava(): com.pulumi.aws.s3control.inputs.MultiRegionAccessPointPolicyDetailsArgs =
        com.pulumi.aws.s3control.inputs.MultiRegionAccessPointPolicyDetailsArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .policy(policy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultiRegionAccessPointPolicyDetailsArgs].
 */
@PulumiTagMarker
public class MultiRegionAccessPointPolicyDetailsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value The name of the Multi-Region Access Point.
     */
    @JvmName("cdkpgnmjpgojasqs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A valid JSON document that specifies the policy that you want to associate with this Multi-Region Access Point. Once applied, the policy can be edited, but not deleted. For more information, see the documentation on [Multi-Region Access Point Permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointPermissions.html).
     * > **NOTE:** When you update the `policy`, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.
     */
    @JvmName("mymrkitllqrkpbdg")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the Multi-Region Access Point.
     */
    @JvmName("yabsfmrwptpptuvd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A valid JSON document that specifies the policy that you want to associate with this Multi-Region Access Point. Once applied, the policy can be edited, but not deleted. For more information, see the documentation on [Multi-Region Access Point Permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointPermissions.html).
     * > **NOTE:** When you update the `policy`, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.
     */
    @JvmName("ivhtlrvfylsfahty")
    public suspend fun policy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): MultiRegionAccessPointPolicyDetailsArgs =
        MultiRegionAccessPointPolicyDetailsArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            policy = policy ?: throw PulumiNullFieldException("policy"),
        )
}
