@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accountLevel The account-level configurations of the S3 Storage Lens configuration. See Account Level below for more details.
 * @property awsOrg The Amazon Web Services organization for the S3 Storage Lens configuration. See AWS Org below for more details.
 * @property dataExport Properties of S3 Storage Lens metrics export including the destination, schema and format. See Data Export below for more details.
 * @property enabled Whether the S3 Storage Lens configuration is enabled.
 * @property exclude What is excluded in this configuration. Conflicts with `include`. See Exclude below for more details.
 * @property include What is included in this configuration. Conflicts with `exclude`. See Include below for more details.
 */
public data class StorageLensConfigurationStorageLensConfigurationArgs(
    public val accountLevel: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelArgs>,
    public val awsOrg: Output<StorageLensConfigurationStorageLensConfigurationAwsOrgArgs>? = null,
    public val dataExport: Output<StorageLensConfigurationStorageLensConfigurationDataExportArgs>? =
        null,
    public val enabled: Output<Boolean>,
    public val exclude: Output<StorageLensConfigurationStorageLensConfigurationExcludeArgs>? = null,
    public val include: Output<StorageLensConfigurationStorageLensConfigurationIncludeArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationArgs.builder()
            .accountLevel(accountLevel.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .awsOrg(awsOrg?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataExport(dataExport?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .exclude(exclude?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .include(include?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationStorageLensConfigurationArgsBuilder internal constructor() {
    private var accountLevel:
        Output<StorageLensConfigurationStorageLensConfigurationAccountLevelArgs>? = null

    private var awsOrg: Output<StorageLensConfigurationStorageLensConfigurationAwsOrgArgs>? = null

    private var dataExport: Output<StorageLensConfigurationStorageLensConfigurationDataExportArgs>? =
        null

    private var enabled: Output<Boolean>? = null

    private var exclude: Output<StorageLensConfigurationStorageLensConfigurationExcludeArgs>? = null

    private var include: Output<StorageLensConfigurationStorageLensConfigurationIncludeArgs>? = null

    /**
     * @param value The account-level configurations of the S3 Storage Lens configuration. See Account Level below for more details.
     */
    @JvmName("apimwrkpoqmtwjgm")
    public suspend
    fun accountLevel(`value`: Output<StorageLensConfigurationStorageLensConfigurationAccountLevelArgs>) {
        this.accountLevel = value
    }

    /**
     * @param value The Amazon Web Services organization for the S3 Storage Lens configuration. See AWS Org below for more details.
     */
    @JvmName("wftxhpbyafiwlumw")
    public suspend
    fun awsOrg(`value`: Output<StorageLensConfigurationStorageLensConfigurationAwsOrgArgs>) {
        this.awsOrg = value
    }

    /**
     * @param value Properties of S3 Storage Lens metrics export including the destination, schema and format. See Data Export below for more details.
     */
    @JvmName("swilpjeiaceuvttd")
    public suspend
    fun dataExport(`value`: Output<StorageLensConfigurationStorageLensConfigurationDataExportArgs>) {
        this.dataExport = value
    }

    /**
     * @param value Whether the S3 Storage Lens configuration is enabled.
     */
    @JvmName("dkfkyuoawfkpeloy")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value What is excluded in this configuration. Conflicts with `include`. See Exclude below for more details.
     */
    @JvmName("nqhbiuvisqcetfky")
    public suspend
    fun exclude(`value`: Output<StorageLensConfigurationStorageLensConfigurationExcludeArgs>) {
        this.exclude = value
    }

    /**
     * @param value What is included in this configuration. Conflicts with `exclude`. See Include below for more details.
     */
    @JvmName("ejujjklwetxbemqj")
    public suspend
    fun include(`value`: Output<StorageLensConfigurationStorageLensConfigurationIncludeArgs>) {
        this.include = value
    }

    /**
     * @param value The account-level configurations of the S3 Storage Lens configuration. See Account Level below for more details.
     */
    @JvmName("qanneqdhdjqbvttj")
    public suspend
    fun accountLevel(`value`: StorageLensConfigurationStorageLensConfigurationAccountLevelArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountLevel = mapped
    }

    /**
     * @param argument The account-level configurations of the S3 Storage Lens configuration. See Account Level below for more details.
     */
    @JvmName("stfexnmxpmtlbqge")
    public suspend
    fun accountLevel(argument: suspend StorageLensConfigurationStorageLensConfigurationAccountLevelArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAccountLevelArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.accountLevel = mapped
    }

    /**
     * @param value The Amazon Web Services organization for the S3 Storage Lens configuration. See AWS Org below for more details.
     */
    @JvmName("vncsbragwqmxaepy")
    public suspend fun awsOrg(`value`: StorageLensConfigurationStorageLensConfigurationAwsOrgArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsOrg = mapped
    }

    /**
     * @param argument The Amazon Web Services organization for the S3 Storage Lens configuration. See AWS Org below for more details.
     */
    @JvmName("cktdignbgijfjxmi")
    public suspend
    fun awsOrg(argument: suspend StorageLensConfigurationStorageLensConfigurationAwsOrgArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationAwsOrgArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.awsOrg = mapped
    }

    /**
     * @param value Properties of S3 Storage Lens metrics export including the destination, schema and format. See Data Export below for more details.
     */
    @JvmName("oesmcuphuksbdqwd")
    public suspend
    fun dataExport(`value`: StorageLensConfigurationStorageLensConfigurationDataExportArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataExport = mapped
    }

    /**
     * @param argument Properties of S3 Storage Lens metrics export including the destination, schema and format. See Data Export below for more details.
     */
    @JvmName("ahemaiygkgyiabox")
    public suspend
    fun dataExport(argument: suspend StorageLensConfigurationStorageLensConfigurationDataExportArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationDataExportArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataExport = mapped
    }

    /**
     * @param value Whether the S3 Storage Lens configuration is enabled.
     */
    @JvmName("gjtxkhoqleidqwtc")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value What is excluded in this configuration. Conflicts with `include`. See Exclude below for more details.
     */
    @JvmName("lmtkjtamktkcsbgo")
    public suspend
    fun exclude(`value`: StorageLensConfigurationStorageLensConfigurationExcludeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclude = mapped
    }

    /**
     * @param argument What is excluded in this configuration. Conflicts with `include`. See Exclude below for more details.
     */
    @JvmName("modryyeilsrqkmqj")
    public suspend
    fun exclude(argument: suspend StorageLensConfigurationStorageLensConfigurationExcludeArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationExcludeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.exclude = mapped
    }

    /**
     * @param value What is included in this configuration. Conflicts with `exclude`. See Include below for more details.
     */
    @JvmName("levspqbcjlrrufnu")
    public suspend
    fun include(`value`: StorageLensConfigurationStorageLensConfigurationIncludeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.include = mapped
    }

    /**
     * @param argument What is included in this configuration. Conflicts with `exclude`. See Include below for more details.
     */
    @JvmName("epwxdhwreslceuje")
    public suspend
    fun include(argument: suspend StorageLensConfigurationStorageLensConfigurationIncludeArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationIncludeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.include = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationArgs =
        StorageLensConfigurationStorageLensConfigurationArgs(
            accountLevel = accountLevel ?: throw PulumiNullFieldException("accountLevel"),
            awsOrg = awsOrg,
            dataExport = dataExport,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            exclude = exclude,
            include = include,
        )
}
