@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAwsOrgArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the Amazon Web Services organization.
 */
public data class StorageLensConfigurationStorageLensConfigurationAwsOrgArgs(
    public val arn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAwsOrgArgs> {
    override fun toJava():
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAwsOrgArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationAwsOrgArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationAwsOrgArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationStorageLensConfigurationAwsOrgArgsBuilder internal
constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Web Services organization.
     */
    @JvmName("efqwtbcbsgkfwlls")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Web Services organization.
     */
    @JvmName("ltwxiclpqtldbrjs")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationAwsOrgArgs =
        StorageLensConfigurationStorageLensConfigurationAwsOrgArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
        )
}
