@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudWatchMetrics Amazon CloudWatch publishing for S3 Storage Lens metrics. See Cloud Watch Metrics below for more details.
 * @property s3BucketDestination The bucket where the S3 Storage Lens metrics export will be located. See S3 Bucket Destination below for more details.
 */
public data class StorageLensConfigurationStorageLensConfigurationDataExportArgs(
    public val cloudWatchMetrics:
    Output<StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs>? =
        null,
    public val s3BucketDestination:
    Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs> {
    override fun toJava():
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportArgs.builder()
            .cloudWatchMetrics(cloudWatchMetrics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3BucketDestination(
                s3BucketDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationDataExportArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationStorageLensConfigurationDataExportArgsBuilder internal
constructor() {
    private var cloudWatchMetrics:
        Output<StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs>? =
        null

    private var s3BucketDestination:
        Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs>? =
        null

    /**
     * @param value Amazon CloudWatch publishing for S3 Storage Lens metrics. See Cloud Watch Metrics below for more details.
     */
    @JvmName("lpqotebmfjlgqbej")
    public suspend
    fun cloudWatchMetrics(`value`: Output<StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs>) {
        this.cloudWatchMetrics = value
    }

    /**
     * @param value The bucket where the S3 Storage Lens metrics export will be located. See S3 Bucket Destination below for more details.
     */
    @JvmName("hqfntkcpgxkyhvfj")
    public suspend
    fun s3BucketDestination(`value`: Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs>) {
        this.s3BucketDestination = value
    }

    /**
     * @param value Amazon CloudWatch publishing for S3 Storage Lens metrics. See Cloud Watch Metrics below for more details.
     */
    @JvmName("sgnxtsooidynfxge")
    public suspend
    fun cloudWatchMetrics(`value`: StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudWatchMetrics = mapped
    }

    /**
     * @param argument Amazon CloudWatch publishing for S3 Storage Lens metrics. See Cloud Watch Metrics below for more details.
     */
    @JvmName("jecpdikuqwakhqat")
    public suspend
    fun cloudWatchMetrics(argument: suspend StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationDataExportCloudWatchMetricsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudWatchMetrics = mapped
    }

    /**
     * @param value The bucket where the S3 Storage Lens metrics export will be located. See S3 Bucket Destination below for more details.
     */
    @JvmName("wvosgmcacnengbuf")
    public suspend
    fun s3BucketDestination(`value`: StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketDestination = mapped
    }

    /**
     * @param argument The bucket where the S3 Storage Lens metrics export will be located. See S3 Bucket Destination below for more details.
     */
    @JvmName("jtedhmhprqyhhbsm")
    public suspend
    fun s3BucketDestination(argument: suspend StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3BucketDestination = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationDataExportArgs =
        StorageLensConfigurationStorageLensConfigurationDataExportArgs(
            cloudWatchMetrics = cloudWatchMetrics,
            s3BucketDestination = s3BucketDestination,
        )
}
