@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property sseKms SSE-KMS encryption. See SSE KMS below for more details.
 * @property sseS3s SSE-S3 encryption. An empty configuration block `{}` should be used.
 */
public data class
StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs(
    public val sseKms:
    Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKmsArgs>? =
        null,
    public val sseS3s:
    Output<List<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Args>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs> {
    override fun toJava():
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs.builder()
            .sseKms(sseKms?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sseS3s(
                sseS3s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs].
 */
@PulumiTagMarker
public class
StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgsBuilder
internal constructor() {
    private var sseKms:
        Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKmsArgs>? =
        null

    private var sseS3s:
        Output<List<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Args>>? =
        null

    /**
     * @param value SSE-KMS encryption. See SSE KMS below for more details.
     */
    @JvmName("qeqwqhqaxsnivhma")
    public suspend
    fun sseKms(`value`: Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKmsArgs>) {
        this.sseKms = value
    }

    /**
     * @param value SSE-S3 encryption. An empty configuration block `{}` should be used.
     */
    @JvmName("lpkybwxahwwwpais")
    public suspend
    fun sseS3s(`value`: Output<List<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Args>>) {
        this.sseS3s = value
    }

    @JvmName("iqyjpeqoxdlduhmb")
    public suspend fun sseS3s(
        vararg
        values: Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Args>,
    ) {
        this.sseS3s = Output.all(values.asList())
    }

    /**
     * @param values SSE-S3 encryption. An empty configuration block `{}` should be used.
     */
    @JvmName("nbeyhdcgkdsuwbxk")
    public suspend
    fun sseS3s(values: List<Output<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Args>>) {
        this.sseS3s = Output.all(values)
    }

    /**
     * @param value SSE-KMS encryption. See SSE KMS below for more details.
     */
    @JvmName("ghjikwonxwjwchde")
    public suspend
    fun sseKms(`value`: StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKmsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseKms = mapped
    }

    /**
     * @param argument SSE-KMS encryption. See SSE KMS below for more details.
     */
    @JvmName("dtpbinagcjohvhii")
    public suspend
    fun sseKms(argument: suspend StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKmsArgsBuilder.() -> Unit) {
        val toBeMapped =
            StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseKmsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sseKms = mapped
    }

    /**
     * @param value SSE-S3 encryption. An empty configuration block `{}` should be used.
     */
    @JvmName("ewauydbevcjywsrw")
    public suspend
    fun sseS3s(`value`: List<StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseS3s = mapped
    }

    /**
     * @param argument SSE-S3 encryption. An empty configuration block `{}` should be used.
     */
    @JvmName("suxcyeqijtimjmxl")
    public suspend
    fun sseS3s(argument: List<suspend StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sseS3s = mapped
    }

    /**
     * @param argument SSE-S3 encryption. An empty configuration block `{}` should be used.
     */
    @JvmName("uhiftcfmsicydxif")
    public suspend fun sseS3s(
        vararg
        argument: suspend StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3ArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sseS3s = mapped
    }

    /**
     * @param argument SSE-S3 encryption. An empty configuration block `{}` should be used.
     */
    @JvmName("sdmqrmtgrfjvkndd")
    public suspend
    fun sseS3s(argument: suspend StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3ArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3ArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.sseS3s = mapped
    }

    /**
     * @param values SSE-S3 encryption. An empty configuration block `{}` should be used.
     */
    @JvmName("korohirgwffyjhcc")
    public suspend fun sseS3s(
        vararg
        values: StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionSseS3Args,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sseS3s = mapped
    }

    internal fun build():
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs =
        StorageLensConfigurationStorageLensConfigurationDataExportS3BucketDestinationEncryptionArgs(
            sseKms = sseKms,
            sseS3s = sseS3s,
        )
}
