@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.inputs

import com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationIncludeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property buckets List of S3 bucket ARNs.
 * @property regions List of AWS Regions.
 */
public data class StorageLensConfigurationStorageLensConfigurationIncludeArgs(
    public val buckets: Output<List<String>>? = null,
    public val regions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationIncludeArgs> {
    override fun toJava():
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationIncludeArgs =
        com.pulumi.aws.s3control.inputs.StorageLensConfigurationStorageLensConfigurationIncludeArgs.builder()
            .buckets(buckets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [StorageLensConfigurationStorageLensConfigurationIncludeArgs].
 */
@PulumiTagMarker
public class StorageLensConfigurationStorageLensConfigurationIncludeArgsBuilder internal
constructor() {
    private var buckets: Output<List<String>>? = null

    private var regions: Output<List<String>>? = null

    /**
     * @param value List of S3 bucket ARNs.
     */
    @JvmName("xgfnqqbvygmyehvx")
    public suspend fun buckets(`value`: Output<List<String>>) {
        this.buckets = value
    }

    @JvmName("ikknkmotskgtybat")
    public suspend fun buckets(vararg values: Output<String>) {
        this.buckets = Output.all(values.asList())
    }

    /**
     * @param values List of S3 bucket ARNs.
     */
    @JvmName("cgmvtadytkaoevro")
    public suspend fun buckets(values: List<Output<String>>) {
        this.buckets = Output.all(values)
    }

    /**
     * @param value List of AWS Regions.
     */
    @JvmName("qrdoidcjtdqaowjk")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("btossayjyauxguvm")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values List of AWS Regions.
     */
    @JvmName("bntujrxxovbtknpr")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value List of S3 bucket ARNs.
     */
    @JvmName("nhexgxbhwqvwhduf")
    public suspend fun buckets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buckets = mapped
    }

    /**
     * @param values List of S3 bucket ARNs.
     */
    @JvmName("ymckykqhxyguwdpu")
    public suspend fun buckets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buckets = mapped
    }

    /**
     * @param value List of AWS Regions.
     */
    @JvmName("mgvjxvyibxheoojv")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values List of AWS Regions.
     */
    @JvmName("paaokdloqspreydq")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    internal fun build(): StorageLensConfigurationStorageLensConfigurationIncludeArgs =
        StorageLensConfigurationStorageLensConfigurationIncludeArgs(
            buckets = buckets,
            regions = regions,
        )
}
