@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property prefix Object prefix for rule filtering.
 * @property tags Key-value map of object tags for rule filtering.
 */
public data class BucketLifecycleConfigurationRuleFilter(
    public val prefix: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.BucketLifecycleConfigurationRuleFilter):
            BucketLifecycleConfigurationRuleFilter = BucketLifecycleConfigurationRuleFilter(
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
