@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name
 * @property publicAccessBlock
 * @property regions
 */
public data class MultiRegionAccessPointDetails(
    public val name: String,
    public val publicAccessBlock: MultiRegionAccessPointDetailsPublicAccessBlock? = null,
    public val regions: List<MultiRegionAccessPointDetailsRegion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.MultiRegionAccessPointDetails):
            MultiRegionAccessPointDetails = MultiRegionAccessPointDetails(
            name = javaType.name(),
            publicAccessBlock = javaType.publicAccessBlock().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.MultiRegionAccessPointDetailsPublicAccessBlock.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3control.kotlin.outputs.MultiRegionAccessPointDetailsRegion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
