@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket
 * @property bucketAccountId
 * @property region
 */
public data class MultiRegionAccessPointDetailsRegion(
    public val bucket: String,
    public val bucketAccountId: String? = null,
    public val region: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3control.outputs.MultiRegionAccessPointDetailsRegion):
            MultiRegionAccessPointDetailsRegion = MultiRegionAccessPointDetailsRegion(
            bucket = javaType.bucket(),
            bucketAccountId = javaType.bucketAccountId().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
